# Some basic setup:
# Setup detectron2 logger
import detectron2
from detectron2.utils.logger import setup_logger
setup_logger()
setup_logger(name="mask2former")
from PIL import Image
# import some common libraries
import numpy as np
import cv2
import torch
import SimpleITK as itk
# import some common detectron2 utilities
from detectron2.engine import DefaultPredictor
from detectron2.config import get_cfg
from detectron2.data import MetadataCatalog
from detectron2.projects.deeplab import add_deeplab_config
import os 
# import Mask2Former project
from mask2former import add_maskformer2_config
from tqdm import tqdm  

cfg = get_cfg()
add_deeplab_config(cfg)
add_maskformer2_config(cfg)
cfg.merge_from_file("")
cfg.MODEL.WEIGHTS = ''
cfg.MODEL.MASK_FORMER.TEST.SEMANTIC_ON = True

predictor = DefaultPredictor(cfg)

cdir = ""
path_list = os.listdir(cdir)
path_list.sort()
for casei in tqdm(path_list[:]):
    img_path = cdir + '/' + casei
    im = Image.open(img_path)
    imm = np.array(im)
    outputs = predictor(imm)
    
    semantic_result = outputs["sem_seg"].argmax(0).to("cpu")
    img_np = np.array(semantic_result)

    img = Image.fromarray(img_np.astype(np.uint8))
    img.save(''%casei[:-4])








